#!/bin/sh

#########################################################################
# cacti script for QNAP TS-459 Pro+
# http://pnpk.net
#
# If you want hdusedsize status then you install bc your system.
# If you not install bc, please comment out hdusedsize.
# Path   <path_cacti>/scripts/QNAP-GetStatus.sh
# Usage  /var/www/html/scripts/QNAP-GetStatus.sh <ip> <snmp_community>
#
#########################################################################

systemcpu=`/usr/bin/snmpget -v1  -c $2 $1 .1.3.6.1.4.1.24681.1.2.1.0 |cut -d\" -f2 | cut -d' ' -f1 |awk '{ printf($1) }'`

hdtotalsize=`/usr/bin/snmpget -v1  -c $2 $1 .1.3.6.1.4.1.24681.1.2.17.1.4.1 |cut -d\" -f2 | cut -d' ' -f1 |awk '{ printf($1) }'`
hdfreesize=`/usr/bin/snmpget -v1  -c $2 $1 .1.3.6.1.4.1.24681.1.2.17.1.5.1 |cut -d\" -f2 | cut -d' ' -f1 |awk '{ printf($1) }'`
hdusedsize=`echo $hdtotalsize - $hdfreesize | bc|awk '{ printf($1) }'`

fanspeed=`/usr/bin/snmpget -v1  -c $2 $1 .1.3.6.1.4.1.24681.1.2.15.1.3.1 |cut -d\" -f2 | cut -d' ' -f1 |awk '{ printf($1) }'`
cputemp=`/usr/bin/snmpget  -v1  -c $2 $1 .1.3.6.1.4.1.24681.1.2.5.0 |cut -d\" -f2 | cut -d' ' -f1 |awk '{ printf($1) }'`
systemp=`/usr/bin/snmpget  -v1  -c $2 $1 .1.3.6.1.4.1.24681.1.2.6.0 |cut -d\" -f2 | cut -d' ' -f1 |awk '{ printf($1) }'`

hd1temp=`/usr/bin/snmpget  -v1  -c $2 $1 .1.3.6.1.4.1.24681.1.2.11.1.3.1 |cut -d\" -f2 | cut -d' ' -f1 |awk '{ printf($1) }'`
hd2temp=`/usr/bin/snmpget  -v1  -c $2 $1 .1.3.6.1.4.1.24681.1.2.11.1.3.2 |cut -d\" -f2 | cut -d' ' -f1 |awk '{ printf($1) }'`
hd3temp=`/usr/bin/snmpget  -v1  -c $2 $1 .1.3.6.1.4.1.24681.1.2.11.1.3.3 |cut -d\" -f2 | cut -d' ' -f1 |awk '{ printf($1) }'`
hd4temp=`/usr/bin/snmpget  -v1  -c $2 $1 .1.3.6.1.4.1.24681.1.2.11.1.3.4 |cut -d\" -f2 | cut -d' ' -f1 |awk '{ printf($1) }'`

freemem=`/usr/bin/snmpget  -v1  -c $2 $1 .1.3.6.1.4.1.24681.1.2.3.0 |cut -d\" -f2 | cut -d' ' -f1 |awk '{ printf($1) }'`
totalmem=`/usr/bin/snmpget -v1  -c $2 $1 .1.3.6.1.4.1.24681.1.2.2.0 |cut -d\" -f2 | cut -d' ' -f1 |awk '{ printf($1) }'`

{
	printf ' systemcpu:'$systemcpu
	printf ' hdtotalsize:'$hdtotalsize
	printf ' hdfreesize:'$hdfreesize
	printf ' hdusedsize:'$hdusedsize
	printf ' fanspeed:'$fanspeed
	printf ' cputemp:'$cputemp
	printf ' systemp:'$systemp
	printf ' hd1temp:'$hd1temp
	printf ' hd2temp:'$hd2temp
	printf ' hd3temp:'$hd3temp
	printf ' hd4temp:'$hd4temp
	printf ' freemem:'$freemem
	printf ' totalmem:'$totalmem
} |sort
